unit IWCompLabelWAP;

interface

uses
  {$IFDEF VSNET}
  System.ComponentModel, System.Drawing,
  {$ENDIF}
  Classes, IWControlWAP, IWBaseWAPInterfaces, IWBaseControl, IWBaseRenderContext, IWWapTag,
  IWBaseComponent, IWBaseInterfaces, IWMarkupLanguageTag, IWTypes, IWBaseWapControl,
  IWWAPRenderContext;

type
  TIWCustomLabelWAP = class(TIWCustomControlWAP)
  protected
    FRawText: Boolean;
    procedure InitControl; override;
    {$IFDEF VSNET}
    function getText: string; reintroduce;virtual;
    procedure setText(AValue: string); reintroduce;virtual;
    {$ENDIF}
  public
    function RenderWap(AContext: TIWBaseWapComponentContext): TIWWapTag; override;

    {$IFDEF VSNET}
    property Text: string read getText write setText;
    {$ENDIF}

    property RawText: Boolean read FRawText write FRawText;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWLabelWAP.bmp}
  TIWLabelWAP = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWLabelWAP), 'TIWLabelWAP.bmp')]
  {$ENDIF}
  TIWLabelWAP = class(TIWCustomLabelWAP)
  published
    {$IFDEF VSNET}
    property Text;
    {$ELSE}
    property Caption;
    {$ENDIF}
    property RawText;
  end;

implementation

uses
  {$IFDEF VSNET}
  IWNetBaseControl,
  {$ENDIF}
  SysUtils;

{ TIWCustomLabelWAP }

{$IFDEF VSNET}
function TIWCustomLabelWAP.getText: string; 
begin
  Result := Caption;
end;

procedure TIWCustomLabelWAP.setText(AValue: string); 
begin
  Caption := AValue;
  TIWNETBaseControl(Self).Invalidate;
end;
{$ENDIF}

procedure TIWCustomLabelWAP.InitControl;
begin
  inherited;
  Height := 21;
  Width := 121;
end;

function TIWCustomLabelWAP.RenderWap(
  AContext: TIWBaseWAPComponentContext): TIWWapTag;
begin
  if AContext.PageContext.OutputTagType = wotWML then begin
    Result := TIWWAPTag.Create(TIWMarkupLanguageElement(nil));
    try
      if RawText then begin
        Result.Contents.AddText(Caption);
      end else begin
        Result.Contents.AddText(TextToWML(Caption));
      end;
    except
       FreeAndNil(Result);
       raise;
    end;
  end else begin
    Result := TIWWAPTag.CreateWAPTag('span');
    try
      if RawText then begin
        Result.Contents.AddText(Caption);
      end else begin
        Result.Contents.AddText(TextToXHTMLMP(Caption));
      end;
    except
      FreeAndNil(Result);
      Raise;
    end;
  end;
end;

end.
